/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterBlockWithBeginEndNode;
import com.aptana.formatter.nodes.NodeTypes;

public class FormatterPHPParenthesesNode
extends FormatterBlockWithBeginEndNode {
    private boolean asWrapper;
    private boolean newLineBeforeClosing;
    private NodeTypes.TypeBracket parenthesesType;
    private int containedElementsCount;

    public FormatterPHPParenthesesNode(IFormatterDocument document, boolean asWrapper, int containedElementsCount, NodeTypes.TypeBracket type) {
        super(document);
        this.asWrapper = asWrapper;
        this.containedElementsCount = containedElementsCount;
        this.parenthesesType = type;
    }

    public FormatterPHPParenthesesNode(IFormatterDocument document, NodeTypes.TypeBracket type) {
        this(document, false, 0, type);
    }

    public void setNewLineBeforeClosing(boolean newLineBeforeClosing) {
        this.newLineBeforeClosing = newLineBeforeClosing;
    }

    public int getSpacesCountBefore() {
        if (this.isAsWrapper()) {
            return 1;
        }
        switch (this.parenthesesType) {
            case DECLARATION_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.before.declaration.parentheses.opening");
            }
            case ARRAY_PARENTHESIS: 
            case INVOCATION_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.before.invocation.parentheses.opening");
            }
            case ARRAY_SQUARE: {
                return this.getInt("php.formatter.spaces.before.array.access.parentheses.opening");
            }
            case CONDITIONAL_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.before.conditional.parentheses.opening");
            }
            case LOOP_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.before.loop.parentheses.opening");
            }
        }
        return 0;
    }

    protected void acceptBody(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        int spacesBeforeBody = this.getSpacesBeforeBody();
        if (spacesBeforeBody > 0) {
            this.writeSpaces(visitor, context, spacesBeforeBody);
        }
        super.acceptBody(context, visitor);
        int spacesAfterBody = this.getSpacesAfterBody();
        if (spacesAfterBody > 0) {
            this.writeSpaces(visitor, context, spacesAfterBody);
        }
    }

    public boolean shouldConsumePreviousWhiteSpaces() {
        return true;
    }

    public boolean isAsWrapper() {
        return this.asWrapper;
    }

    protected boolean isIndenting() {
        switch (this.parenthesesType) {
            case ARRAY_PARENTHESIS: {
                return this.getDocument().getBoolean("php.formatter.newline.between.array.creation.elements");
            }
        }
        return super.isIndenting();
    }

    protected boolean isAddingEndNewLine() {
        if (!this.asWrapper && this.newLineBeforeClosing) {
            return true;
        }
        switch (this.parenthesesType) {
            case ARRAY_PARENTHESIS: {
                if (this.containedElementsCount <= 1) break;
                return this.getDocument().getBoolean("php.formatter.newline.between.array.creation.elements");
            }
        }
        return false;
    }

    private int getSpacesBeforeBody() {
        if (this.isAsWrapper()) {
            return 0;
        }
        switch (this.parenthesesType) {
            case DECLARATION_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.after.declaration.parentheses.opening");
            }
            case ARRAY_PARENTHESIS: 
            case INVOCATION_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.after.invocation.parentheses.opening");
            }
            case ARRAY_SQUARE: {
                return this.getInt("php.formatter.spaces.after.array.access.parentheses.opening");
            }
            case CONDITIONAL_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.after.conditional.parentheses.opening");
            }
            case LOOP_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.after.loop.parentheses.opening");
            }
        }
        return 0;
    }

    private int getSpacesAfterBody() {
        if (this.isAsWrapper()) {
            return 0;
        }
        switch (this.parenthesesType) {
            case DECLARATION_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.before.declaration.parentheses.closing");
            }
            case ARRAY_PARENTHESIS: 
            case INVOCATION_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.before.invocation.parentheses.closing");
            }
            case ARRAY_SQUARE: {
                return this.getInt("php.formatter.spaces.before.array.access.parentheses.closing");
            }
            case CONDITIONAL_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.before.conditional.parentheses.closing");
            }
            case LOOP_PARENTHESIS: {
                return this.getInt("php.formatter.spaces.before.loop.parentheses.closing");
            }
        }
        return 0;
    }
}

